package jp.odakyu.toiletsignage.json;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by agentec on 2017/12/08.
 */

public class ResultToiletJson {
    /**
     * JSON Param
     */
    public static final String KEY_CODE = "code";
    public static final String KEY_RESULT = "result";
    public static final String VALUE_STATUS_OPEN = "open";

    private static final String KEY_ID = "id";
    private static final String KEY_NAME = "name";
    private static final String KEY_STATUS = "status";
    private static final String KEY_CHANGED_AT = "changed_at";
    private static final String KEY_ELAPSED_SECONDS = "elapsed_seconds";

    private int id;
    private String name;
    private String status;
    private String changed_at;
    private int elapsed_seconds;

    public int getId() {return id;}
    public String getName() {
        return name;
    }
    public String getStatus() {
        return status;
    }
    public String getChangedAT() {
        return changed_at;
    }
    public int getElapsedSeconds() {
        return elapsed_seconds;
    }

    public ResultToiletJson(JSONObject jsonObject) throws JSONException {
        id = jsonObject.getInt(KEY_ID);
        name = jsonObject.getString(KEY_NAME);
        status = jsonObject.getString(KEY_STATUS);
        changed_at = jsonObject.getString(KEY_CHANGED_AT);
        elapsed_seconds = jsonObject.getInt(KEY_ELAPSED_SECONDS);
    }
}
