package jp.odakyu.toiletsignage.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import jp.odakyu.toiletsignage.activity.MainActivity;
import jp.odakyu.toiletsignage.application.ToiletApplication;

/**
 * 端末の電源がONしたときに自動的にアプリを起動させるレシーバー
 * Created by agentec on 2017/12/18.
 */

public class OnBootReceiver extends BroadcastReceiver {
    public static final String TAG = "OnBootReceiver";
    @Override
    public void onReceive(Context context, Intent intent) {
        Log.i(TAG, "Power ON");
        ToiletApplication application = (ToiletApplication)context.getApplicationContext();
        Log.i(TAG, "application = " + application + "application.getUpdateToiletInfoTimer() = " + application.getUpdateToiletInfoTimer());
        if (application == null || application.getUpdateToiletInfoTimer() == null) {
            Intent i = new Intent(context, MainActivity.class);
            i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(i);
        } else {
            Log.i(TAG, "Starting Application");
        }
    }
}
