package jp.odakyu.toiletsignage.json;

import org.json.JSONException;
import org.json.JSONObject;

import jp.odakyu.toiletsignage.info.ToiletInfo;

/**
 * Created by agentec on 2017/12/08.
 */

public class USBToiletDefaultJson {
    /**
     * JSON Param
     */
    private static final String KEY_PRIORITY = "priority";
    private static final String KEY_TOILET_ID = "toiletId";
    private static final String KEY_TOILET_SEX = "toiletSex";
    private static final String KEY_TOILET_NAME_EN = "toiletName_en";
    private static final String KEY_TOILET_NAME_JP = "toiletName_jp";

    private int priority;
    private int toiletId;
    private int toiletSex;
    private String toiletName_en;
    private String toiletName_jp;

    public int getPriority() {
        return priority;
    }
    public int getToiletId() {
        return toiletId;
    }
    public int getToiletSex() {return toiletSex;}
    public String getToiletNameEN() {
        return toiletName_en;
    }
    public String getToiletNameJP() {
        return toiletName_jp;
    }


    public USBToiletDefaultJson(JSONObject jsonObject) throws JSONException {
        priority = jsonObject.getInt(KEY_PRIORITY);
        toiletId = jsonObject.getInt(KEY_TOILET_ID);
        toiletSex = jsonObject.getInt(KEY_TOILET_SEX);

        if (jsonObject.has(KEY_TOILET_NAME_EN)) {
            toiletName_en = jsonObject.getString(KEY_TOILET_NAME_EN);
        }

        if (jsonObject.has(KEY_TOILET_NAME_JP)) {
            toiletName_jp = jsonObject.getString(KEY_TOILET_NAME_JP);
        }
    }

    public boolean validation(JSONObject jsonObject) {
        if (!jsonObject.has(KEY_PRIORITY)) {
            return false;
        }

        if (!jsonObject.has(KEY_TOILET_ID)) {
            return false;
        }

        if (!jsonObject.has(KEY_TOILET_SEX)) {
            return false;
        }

        if (getToiletId() < 0 || getToiletId() > 1000000) {
            return false;
        }

        if (getToiletSex() != ToiletInfo.VALUE_SEX_MAN && getToiletSex() != ToiletInfo.VALUE_SEX_WOMAN) {
            return false;
        }

        return !(getPriority() != ToiletInfo.VALUE_PRIORITY_MAIN &&
                getPriority() != ToiletInfo.VALUE_PRIORITY_SUB_LEFT &&
                getPriority() != ToiletInfo.VALUE_PRIORITY_SUB_RIGHT);
    }
}
