package jp.odakyu.toiletsignage.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import jp.odakyu.toiletsignage.activity.MainActivity;

/**
 * 端末の電源がONしたときに自動的にアプリを起動させるレシーバー
 * Created by agentec on 2017/12/18.
 */

public class OnBootReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals(Intent.ACTION_BOOT_COMPLETED)) {
            if (intent != null) {
                    Intent i = new Intent(context, MainActivity.class);
                    i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    context.startActivity(i);
            }
        }
    }
}
