package jp.odakyu.toiletsignage.util;

/**
 * 日付や時刻を表すフォーマットの集合です。
 * @author Taejin Hong
 * @version 
 */
public class DateTimeFormat {
	/**
	 * 4桁の年を示します。"yyyy"
	 * @since 1.0.0
	 */
	public static final String yyyy = "yyyy";
	/**
	 * 2桁の月を示します。"MM"
	 * @since 1.0.0
	 */
	public static final String MM = "MM";
	/**
	 * 2桁の日を示します。"dd"
	 * @since 1.0.0
	 */
	public static final String dd = "dd";
	
	/**
	 * 2桁の時を示します。"HH"
	 * @since 1.0.0
	 */
	public static final String HH = "HH";
	/**
	 * 2桁の分を示します。"mm"
	 * @since 1.0.0
	 */
	public static final String mm = "mm";
	/**
	 * 2桁の秒を示します。"ss"
	 * @since 1.0.0
	 */
	public static final String ss = "ss";
	/**
	 * 3桁の秒を示します。"SSS"
	 * @since 1.0.0
	 */
	public static final String SSS = "SSS";
	
	/**
	 * 日付を示します。"yyyymm"
	 * @since 1.0.0
	 */
	public static final String yyyyMM_none = "yyyymm";
	/**
	 * 日付を示します。"yyyy/mm"
	 * @since 1.0.0
	 */
	public static final String yyyyMM_slash = "yyyy/mm";
	/**
	 * 日付を示します。"yyyy-mm"
	 * @since 1.0.0
	 */
	public static final String yyyyMM_hyphen = "yyyy-mm";

	/**
	 * 日付を示します。"yyyyMMdd"
	 * @since 1.0.0
	 */
	public static final String yyyyMMdd_none = "yyyyMMdd";
	/**
	 * 日付を示します。"yyyy/MM/dd"
	 * @since 1.0.0
	 */
	public static final String yyyyMMdd_slash = "yyyy/MM/dd";
	/**
	 * 日付を示します。"yyyy-MM-dd"
	 * @since 1.0.0
	 */
	public static final String yyyyMMdd_hyphen = "yyyy-MM-dd";
	/**
	 * 日付を示します。"yyyy.MM.dd"
	 * @since 1.0.0
	 */
	public static final String yyyyMMdd_dot = "yyyy.MM.dd";
	/**
	 * 日付を示します。"MMdd"
	 * @since 1.0.0
	 */
	public static final String MMdd_none = "MMdd";
	/**
	 * 日付を示します。"MM/dd"
	 * @since 1.0.0
	 */
	public static final String MMdd_slash = "MM/dd";
	/**
	 * 日付を示します。"MM-dd"
	 * @since 1.0.0
	 */
	public static final String MMdd_hyphen = "MM-dd";
	
	/**
	 * 日付を示します。"MM-dd"
	 * @since 1.0.0
	 */
	public static final String MMddHHmm_hyphen = "MM-dd HH:mm";
	
	/**
	 * 日付を示します。"yyyyMMddHH"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHH_none = "yyyyMMddHH";
	/**
	 * 日付を示します。"yyyy/MM/dd HH"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHH_slash = "yyyy/MM/dd HH";
	/**
	 * 日付を示します。"yyyy-MM-dd HH"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHH_hyphen = "yyyy-MM-dd HH";
	
	/**
	 * 日付を示します。"yyyyMMddHH00"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHH00_none = "yyyyMMddHH00";
	/**
	 * 日付を示します。"yyyy/MM/dd HH:00"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHH00_slash = "yyyy/MM/dd HH:00";
	/**
	 * 日付を示します。"yyyy-MM-dd HH:00"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHH00_hyphen = "yyyy-MM-dd HH:00";
	
	/**
	 * 日付を示します。"yyyyMMddHHmm"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmm_none = "yyyyMMddHHmm";
	/**
	 * 日付を示します。"yyyy/MM/dd HH:mm"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmm_slash = "yyyy/MM/dd HH:mm";
	/**
	 * 日付を示します。"yyyy-MM-dd HH:mm"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmm_hyphen = "yyyy-MM-dd HH:mm";
	
	/**
	 * 日付を示します。"yyyyMMddHHmm00"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmm00_none = "yyyyMMddHHmm00";
	/**
	 * 日付を示します。"yyyy/MM/dd HH:mm:00"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmm00_slash = "yyyy/MM/dd HH:mm:00";
	/**
	 * 日付を示します。"yyyy-MM-dd HH:mm:00"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmm00_hyphen = "yyyy-MM-dd HH:mm:00";
	
	/**
	 * 日付を示します。"yyyyMMddHHmmss"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmss_none = "yyyyMMddHHmmss";
	/**
	 * 日付を示します。"yyyy/MM/dd HH:mm:ss"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmss_slash = "yyyy/MM/dd HH:mm:ss";
	/**
	 * 日付を示します。"yyyy-MM-dd HH:mm:ss"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmss_hyphen = "yyyy-MM-dd HH:mm:ss";
	
	public static final String MMddHHmmssSSS_hyphen = "MM-dd HH:mm:ss.SSS";

	/**
	 * 日付を示します。"yyyyMMddHHmmss000"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmss000_none = "yyyyMMddHHmmss000";
	/**
	 * 日付を示します。"yyyy/MM/dd HH:mm:ss.000"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmss000_slash = "yyyy/MM/dd HH:mm:ss.000";
	/**
	 * 日付を示します。"yyyy-MM-dd HH:mm:ss.000"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmss000_hyphen = "yyyy-MM-dd HH:mm:ss.000";
	
	/**
	 * 日付を示します。"yyyyMMddHHmmssSSS"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmssSSS_none = "yyyyMMddHHmmssSSS";
	/**
	 * 日付を示します。"yyyy/MM/dd HH:mm:ss.SSS"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmssSSS_slash = "yyyy/MM/dd HH:mm:ss.SSS";
	/**
	 * 日付を示します。"yyyy-MM-dd HH:mm:ss.SSS"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmssSSS_hyphen = "yyyy-MM-dd HH:mm:ss.SSS";
	
	/**
	 * 日付を示します。"yyyy-MM-dd HH:mm:ss"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmss_TZ = "yyyy-MM-dd'T'HH:mm:ss'Z'";
	
	/**
	 * 日付を示します。"yyyy-MM-ddTHH:mm:ss.SSS"
	 * @since 1.0.0
	 */
	public static final String yyyyMMddHHmmssSSS_TZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

	/**
	 * 日付を示します。 "EEE, dd MMM yyyy HH:mm:ss"
	 * @since 1.0.0
	 */
	public static final String ifModifiedSinceType = "EEE, dd MMM yyyy HH:mm:ss";
	/**
	 * 時間を示します。"HHmm"
	 * @since 1.0.0
	 */
	public static final String HHmm_none = "HHmm";
	/**
	 * 時間を示します。"HH:mm"
	 * @since 1.0.0
	 */
	public static final String HHmm_colon = "HH:mm";
	
	/**
	 * 時間を示します。"HHmmss"
	 * @since 1.0.0
	 */
	public static final String HHmmss_none = "HHmmss";
	/**
	 * 時間を示します。"HH:mm:ss"
	 * @since 1.0.0
	 */
	public static final String HHmmss_colon = "HH:mm:ss";
	
	/**
	 * 時間を示します。"HHmmssSSS"
	 * @since 1.0.0
	 */
	public static final String HHmmssSSS_none = "HHmmssSSS";
	/**
	 * 時間を示します。"HH:mm:ss.SSS"
	 * @since 1.0.0
	 */
	public static final String HHmmssSSS_colon = "HH:mm:ss.SSS";
}
